
var express = require('express')
// bodyParser is a lib that parses POST & PUT data
var bodyParser = require('body-parser')

// add some entities
var people = require("./people/people.js")

var app = express()
var port = process.env.PORT || 8080;

app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())

var people_path = '/people'

app.get(people_path,function (req,res) {
  people.index(function (err,people) {
    res.send(people)
  })
})

app.post(people_path,function (req,res) {
  var person_name = req.body.name
  people.create(person_name,function (err) {
    res.send(err)
  })
})

app.put(people_path+"/:person_id",function (req,res) {
  people.modify(req.params.person_id,req.body.name, function (err) {
    res.send(err)
  })
})

app.delete(people_path+"/:person_id",function (req,res) {
  people.remove(req.params.person_id, function (err) {
    res.send(err)
  })
})

app.listen(port)
