app.controller('peopleCtrl',function ($scope,ngDialog,people) {
  var self = this

  this.load = function () {
    people.index(function (people) {
      console.log(people)
      $scope.people_list = people.data
    })
  }

  this.load()

  $scope.remove = function (item) {
    people.remove(item, self.load)
  }

  $scope.add = function () {
    console.log("adding")
    people.add($scope.name,self.load)
    $scope.name = ''
  }

  $scope.edit = function (person) {
    $scope.editing = person
    ngDialog.open({
      template: '../editPartial.html',
      scope: $scope
    }).closePromise.then(function () {
      self.load()
    })
  }

  $scope.addPet = function (person,pet) {
    people.addPet(person, pet, function () {
      self.load()
      $scope.pet = ''
    })
  }

  $scope.do = function (person,pet) {
    $scope.tperson = person
    $scope.tpet = pet

    ngDialog.open({
      template: '../petEditPartial.html',
      scope: $scope
    }).closePromise.then(function () {
      self.load()
    })
  }

})
