app.service('people', function ($http) {
  this.index = function (callback) {
    $http.get('http://127.0.0.1:8000/people').then(callback)
  }

  this.remove = function (item,callback) {
    $http.delete('http://127.0.0.1:8000/people/'+item._id).then(callback)
  }

  this.add = function (n,callback) {
    $http.post('http://127.0.0.1:8000/people',{name:n}).then(callback)
  }

  this.modify = function (item,callback) {
    $http.put('http://127.0.0.1:8000/people',{person_id: item._id, name: item.name})
    .then(callback)
  }
})

app.controller('peopleCtrl',function ($scope,people) {
  var self = this
  $scope.editing = false

  this.load = function () {
    people.index(function (people) {
      console.log(people)
      $scope.people_list = people.data
    })
  }

  this.load()

  $scope.remove = function (item) {
    people.remove(item, self.load)
  }

  $scope.add = function () {
    console.log("adding")
    people.add($scope.name,self.load)
    $scope.name = ''
  }

  $scope.edit = function (name) {
    $scope.editing = true;
    $scope.e = name
  }

  $scope.save = function (item,e) {
    item.name = e
    console.log(e)
    people.modify(item,function (err) {
      self.load()
      $scope.editing = false
    })
  }

})
