var db = require('../db/db.js')
var mongoose = require('mongoose')

var people = {}

db.once('open',function () {
  people.model = mongoose.model('People',{ name: String })

  people.create = function (personName, callback) {
    var newPeople = new people.model({ name: personName })
    newPeople.save(callback)
  }

  people.modify = function (id,name,callback) {
    people.model.findById(id).then(function (person) {
      person.name = name
      person.save(callback)
    })
  }

  people.remove = function (id,callback) {
    people.model.findById(id).remove(callback)
  }

})

module.exports = people
