app.service('people', function ($http) {
  this.index = function (callback) {
    $http.get('http://127.0.0.1:8000/people').then(callback)
  }

  this.remove = function (item,callback) {
    $http.delete('http://127.0.0.1:8000/people/'+item._id).then(callback)
  }

  this.add = function (n,callback,reject) {
    $http.post('http://127.0.0.1:8000/people',{name:n}).then(callback).catch(reject)
  }

  this.modify = function (item,callback,reject) {
    $http.put('http://127.0.0.1:8000/people',{person_id: item._id, name: item.name})
    .then(callback).catch(reject)
  }

  this.addPet = function (item,pet_name,callback,reject) {
    $http.post('http://127.0.0.1:8000/people/pets',{person_id: item._id, petname: pet_name})
    .then(callback).catch(reject)
  }

  this.removePet = function (item, pet_name, callback) {
    $http.delete('http://127.0.0.1:8000/people/'+item._id+'/pets/'+pet_name)
    .then(callback)
  }

  this.modifyPet = function (item,old_pet_name,new_petname,callback,reject) {
    $http.put('http://127.0.0.1:8000/people/pets',
    {
      person_id: item._id,
      old_petname: old_pet_name,
      new_petname: new_petname
    }).then(callback).catch(reject)
  }
})
