var db = require('../db/db.js')
var mongoose = require('mongoose')
var inquisitor = require('./inquisitor-validator.js')

var people = {}

db.once('open',function () {
  people.schema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true
    },
    pets: Array
  })

  people.schema.pre('save',inquisitor) // let the inquisitor validate and purge
                                       // heretic (erroneous) data

  people.model = mongoose.model('People',people.schema)

  people.index = function (callback) {
    people.model.find({}, callback)
  }

  people.create = function (personName, callback) {
    var newPeople = new people.model({ name: personName })
    newPeople.save(callback)
  }

  people.modify = function (id, name, callback) {
    people.model.findById(id).then(function (person) {
      person.name = name
      person.save(callback)
    })
  }

  people.remove = function (id, callback) {
    people.model.findById(id).remove(callback)
  }

  people.addPet = function (id, pet_name, callback) {
    people.model.findById(id).then(function (person) {
      person.pets.push(pet_name)
      person.save(callback)
    })
  }

  people.removePet = function (id, pet_name, callback) {
    people.model.findById(id).then(function (person) {
      person.pets.splice(person.pets.indexOf(pet_name),1)
      person.save(callback)
    })
  }

  people.modifyPet = function (id, old_pet_name, new_pet_name, callback) {
    people.model.findById(id).then(function (person) {
      person.pets.splice(person.pets.indexOf(old_pet_name),1)
      person.pets.push(new_pet_name)
      person.save(callback)
    })
  }

})

module.exports = people
