package dgpena.siexample.webapp;

import java.util.List;

import javax.persistence.EntityManager;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;

import dgpena.siexample.persistence.Employee;
import dgpena.siexample.persistence.Employees;
import dgpena.siexample.persistence.Project;
import dgpena.siexample.persistence.Projects;

public class ProjectsVM {

	private EntityManager em;
	private Projects projects;
	private Employees employees;
	
	private boolean isEditing = false;
	
	// department under edition...
	private Project currentProject;
	
	@Init
	public void init() {
		this.em = DesktopEntityManagerManager.getDesktopEntityManager();
		this.projects = new Projects(em);
		this.employees = new Employees(em);
	}
	
	public int getProjectParticipants(@BindingParam("p") Project p) {
		return p.getEmployees().size();
	}
	public List<Project> getProjects() {
		return this.projects.findAll();
	}
	
	public List<Employee> getEmployees() {
		return this.employees.findAll();
	}
	
	public Project getCurrentProject() {
		return currentProject;
	}
	
	public void setCurrentProject(Project currentProject) {
		this.currentProject = currentProject;
	}
	
	@Command
	@NotifyChange("currentProject")
	public void newProject() {
		this.isEditing = false;
		this.currentProject = new Project();
	}
	
	@Command
	@NotifyChange("currentProject")
	public void resetEditing() {
		System.out.println(this.currentProject.getName());
		this.currentProject = null;
	}
	
	@Command
	@NotifyChange({"currentProject", "projects"})
	public void saveProject() {
		
		this.em.getTransaction().begin();
			if (!isEditing) {
				this.projects.addNewProject(this.currentProject);
			}
		this.em.getTransaction().commit();
		
		this.currentProject = null;
	}
	
	@Command
	@NotifyChange("projects")
	public void delete(@BindingParam("p") Project department) {
		this.em.getTransaction().begin();
		this.projects.deleteProject(department);
		this.em.getTransaction().commit();
	}
	
	@Command
	@NotifyChange("currentProject")
	public void edit(@BindingParam("p") Project department) {
		this.isEditing = true;
		this.currentProject = department;
	}
}
