package dgpena.siexample.webapp;

import java.util.List;

import javax.persistence.EntityManager;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;

import dgpena.siexample.persistence.Department;
import dgpena.siexample.persistence.Departments;
import dgpena.siexample.persistence.Employee;
import dgpena.siexample.persistence.Employees;

public class EmployeesVM {

	private EntityManager em;
	private Employees employees;
	private Departments departments;
	
	private boolean isEditing = false;
	
	// Employee under edition...
	private Employee currentEmployee;
	
	@Init
	public void init() {
		this.em = DesktopEntityManagerManager.getDesktopEntityManager();
		this.employees = new Employees(em);
		this.departments = new Departments(em);
	}
	
	public List<Employee> getEmployees() {
		return this.employees.findAll();
	}
	
	public List<Department> getDepartments() {
		return this.departments.findAll();
	}
	
	public Employee getCurrentEmployee() {
		return currentEmployee;
	}
	
	public void setCurrentEmployee(Employee currentEmployee) {
		this.currentEmployee = currentEmployee;
	}
	
	@Command
	@NotifyChange("currentEmployee")
	public void newEmployee() {
		this.isEditing = false;
		this.currentEmployee = new Employee();
	}
	
	@Command
	@NotifyChange("currentEmployee")
	public void resetEditing() {
		this.currentEmployee = null;
	}
	
	@Command
	@NotifyChange({"currentEmployee", "employees"})
	public void saveEmployee() {
		
		this.em.getTransaction().begin();
			if (!isEditing) {
				this.employees.addNewEmployee(this.currentEmployee);
			}
		this.em.getTransaction().commit();
		
		this.currentEmployee = null;
	}
	
	@Command
	@NotifyChange("employees")
	public void delete(@BindingParam("e") Employee Employee) {
		this.em.getTransaction().begin();
		this.employees.deleteEmployee(Employee);
		this.em.getTransaction().commit();
	}
	
	@Command
	@NotifyChange("currentEmployee")
	public void edit(@BindingParam("e") Employee Employee) {
		this.isEditing = true;
		this.currentEmployee = Employee;
	}
}
