package dgpena.siexample.webapp;

import java.util.List;

import javax.persistence.EntityManager;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;

import dgpena.siexample.persistence.Department;
import dgpena.siexample.persistence.Departments;

public class DepartmentsVM {

	private EntityManager em;
	private Departments departments;
	
	private boolean isEditing = false;
	
	// department under edition...
	private Department currentDepartment;
	
	@Init
	public void init() {
		this.em = DesktopEntityManagerManager.getDesktopEntityManager();
		this.departments = new Departments(em);
	}
	
	public List<Department> getDepartments() {
		return this.departments.findAll();
	}
	
	public Department getCurrentDepartment() {
		return currentDepartment;
	}
	
	public void setCurrentDepartment(Department currentDepartment) {
		this.currentDepartment = currentDepartment;
	}
	
	@Command
	@NotifyChange("currentDepartment")
	public void newDepartment() {
		this.isEditing = false;
		this.currentDepartment = new Department();
	}
	
	@Command
	@NotifyChange("currentDepartment")
	public void resetEditing() {
		System.out.println(this.currentDepartment.getName());
		this.currentDepartment = null;
	}
	
	@Command
	@NotifyChange({"currentDepartment", "departments"})
	public void saveDepartment() {
		
		this.em.getTransaction().begin();
			if (!isEditing) {
				this.departments.addNewDepartment(this.currentDepartment);
			}
		this.em.getTransaction().commit();
		
		this.currentDepartment = null;
	}
	
	@Command
	@NotifyChange("departments")
	public void delete(@BindingParam("d") Department department) {
		this.em.getTransaction().begin();
		this.departments.deleteDepartment(department);
		this.em.getTransaction().commit();
	}
	
	@Command
	@NotifyChange("currentDepartment")
	public void edit(@BindingParam("d") Department department) {
		this.isEditing = true;
		this.currentDepartment = department;
	}
}
