package dgpena.siexample.persistence;

import static org.junit.Assert.*;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeesTest extends SQLBasedTest {

	@Test
	public void testAddNewEmployee() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('finanzas')", Statement.RETURN_GENERATED_KEYS);
		int deptId = getLastInsertedId(statement);
				
		EntityManager em = emf.createEntityManager();
		
		Departments depts = new Departments(em);
		Department dept = depts.findById(deptId);
		
		Employee e = new Employee();
		e.setName("pepe");
		e.setDepartment(dept);
		

		Employees employees = new Employees(em);
		
		em.getTransaction().begin();
		
			employees.addNewEmployee(e);
			
			// ensure that bi-directional relation is always consistent
			assertEquals(1, dept.getEmployees().size());
			
		em.getTransaction().commit();

		int employeeId = e.getId();
		
		
		statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT * from Employee where id = "+employeeId);
		res.next();
		assertEquals(deptId, res.getInt("department_id"));
		assertEquals("pepe", res.getString("name"));
		
		
	}
	
}
