package dgpena.siexample.persistence;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;

@Entity
@IdClass(ProjectAssignment.ProjectAssignmentId.class)
public class ProjectAssignment {

	@Id
	@ManyToOne
	private Project project;
	
	@Id
	@ManyToOne
	private Employee employee;
	
	
	private Date startDate;
	
	
	public Project getProject() {
		return project;
	}
	
	public Employee getEmployee() {
		return employee;
	}
	
	public void setProject(Project project) {
		if (this.project != null) {
			project.internalRemoveProjectAssignment(this);
		}
		this.project = project;
		
		if (this.project != null) {
			this.project.internalAddProjectAssignment(this);
		}
		this.project = project;
	}
	
	public void setEmployee(Employee employee) {
		this.employee = employee;
	}
	
	public Date getStartDate() {
		return startDate;
	}
	
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	public static class ProjectAssignmentId implements Serializable {
		private int project;
		private int employee;
		
		
		public ProjectAssignmentId() {}
		public ProjectAssignmentId(int project, int employee) {
			super();
			this.project = project;
			this.employee = employee;
		}
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + employee;
			result = prime * result + project;
			return result;
		}
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			ProjectAssignmentId other = (ProjectAssignmentId) obj;
			if (employee != other.employee)
				return false;
			if (project != other.project)
				return false;
			return true;
		}
		
		
	}
	
}
