package dgpena.siexample.persistence;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Project {
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private int id;
	
	private String name;
	
	@OneToMany(mappedBy="project")
	private Set<ProjectAssignment> projectAssignments = new HashSet<>();
	
	public int getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public Set<Employee> getEmployees() {
		Set<Employee> employees = new HashSet<>();
		
		for (ProjectAssignment pa : projectAssignments) {
			employees.add(pa.getEmployee());
		}
		
		return employees;
	}

	void internalRemoveProjectAssignment(ProjectAssignment projectAssignment) {
		this.projectAssignments.remove(projectAssignment);
		
	}

	void internalAddProjectAssignment(ProjectAssignment projectAssignment) {
		this.projectAssignments.add(projectAssignment);
		
	}
	
}
