package dgpena.siexample.persistence;

import java.util.List;

import javax.persistence.EntityManager;

public class Departments {

	private EntityManager em;

	public Departments(EntityManager em) {
		this.em = em;
	}
	
	public void addNewDepartment(Department d) {
		em.persist(d);
	}
	
	public Department findById(int id) {
		return em.find(Department.class, id);
	}

	public void deleteDepartment(Department d) {
		// remove first my employees
		for (Employee e: d.getEmployees()) {
			e.setDepartment(null);
		}
		em.remove(d);
	}

	public List<Department> findAll() {
		return em.createQuery("SELECT d FROM Department d").getResultList();
	}
}
