package dgpena.siexample.persistence;

import static org.junit.Assert.assertEquals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.BeforeClass;
import org.junit.Test;

public class DepartmentsTest extends SQLBasedTest {

	private static EntityManagerFactory emf;
	
	@BeforeClass
	public static void setUpEntityManagerFactory() {
		emf = Persistence.createEntityManagerFactory("si-database");
	}
	
	@Test
	public void testAddNewDepartment() throws Exception {
		
		Department d = new Department();
		d.setName("finanzas");

		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		depts.addNewDepartment(d);
		
		// check in the DB using JDBC
		int deptId = d.getId();
		Statement statement = jdbcConnection.createStatement();
		ResultSet rs = statement.executeQuery("SELECT COUNT(*) as total FROM Department d where d.id = "+deptId);
		rs.next();
		assertEquals(1, rs.getInt("total"));
	}
	
	@Test
	public void testFindById() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('finanzas')", Statement.RETURN_GENERATED_KEYS);
		int deptId = getLastInsertedId(statement);

		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		Department d = depts.findById(deptId);
		
		assertEquals(deptId, d.getId());
		assertEquals("finanzas", d.getName());
		
	}
}
