package dgpena.siexample.persistence;

import static org.junit.Assert.assertEquals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

import javax.persistence.EntityManager;

import org.junit.Test;

public class ProjectsTest extends SQLBasedTest {

	@Test
	public void testAddNewProject() throws SQLException {
		EntityManager em = emf.createEntityManager();
		
		Projects projects = new Projects(em);

		Project p = new Project();
		p.setName("Our best project");


		em.getTransaction().begin();
		
			projects.addNewProject(p);

		em.getTransaction().commit();

		int projectId = p.getId();

		Statement statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT COUNT(*) as total from Project where id = "+projectId);
		res.next();
		assertEquals(1, res.getInt("total"));
	}

	@Test
	public void testAddEmployeeToProject() throws SQLException {

		// insert a project previously with JDBC
		int projectId = insertAProject();

		// insert an employee previously with JDBC
		int employeeId = insertAnEmployee();

		EntityManager em = emf.createEntityManager();

		Projects projects = new Projects(em);
		Project p = projects.findById(projectId);

		Employees employees = new Employees(em);
		Employee e = employees.findById(employeeId);

		em.getTransaction().begin();

			p.addEmployee(e, new Date());

		em.getTransaction().commit();


		// ensure that a ProjectAssignment has been created
		Statement statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT COUNT(*) as total from ProjectAssignment where project_id = " +
				""+projectId+" and employee_id = "+employeeId);
		res.next();
		assertEquals(1, res.getInt("total"));
	}

	@Test
	public void testRemoveEmployeeFromProject() throws SQLException {
		// insert a project previously with JDBC
		int projectId = insertAProject();

		// insert an employee previously with JDBC
		int employeeId = insertAnEmployee();

		// insert a second employee previously with JDBC (this is the employee that will be removed from the project)
		int employeeId2 = insertAnEmployee();


		// assign those employees to the project
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO ProjectAssignment(project_id, employee_id) values("+projectId+", "
				+employeeId2+")", Statement
				.RETURN_GENERATED_KEYS);
		statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO ProjectAssignment(project_id, employee_id) values("+projectId+", "
				+employeeId+")", Statement
				.RETURN_GENERATED_KEYS);

		EntityManager em = emf.createEntityManager();

		em.getTransaction().begin();
			Project p = new Projects(em).findById(projectId);
			Employee e = new Employees(em).findById(employeeId2);

			p.removeEmployee(e);
		em.getTransaction().commit();


		// ensure that the project assignment for employee 2 does not exist
		statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT COUNT(*) as total from ProjectAssignment where employee_id = " +
				""+employeeId2+" and project_id = "+projectId);
		res.next();
		assertEquals(0, res.getInt("total"));
	}
	
	@Test
	public void testCreateProjectAssignment() throws SQLException {
		// insert a project previously with JDBC
		int projectId = insertAProject();

		// insert an employee previously with JDBC
		int employeeId = insertAnEmployee();

		EntityManager em = emf.createEntityManager();

		em.getTransaction().begin();

			Project p = new Projects(em).findById(projectId);
			Employee e = new Employees(em).findById(employeeId);

			ProjectAssignment pa = new ProjectAssignment();
			pa.setProject(p); // pa is automatically added to the Project.projectAssignments collection
			pa.setEmployee(e);
			pa.setStartDate(new Date());
			// the ProjectAssignment is automatically persisted due to CascadeType.PERSIST present in Project.projectAssignments

		em.getTransaction().commit();

		// ensure that a ProjectAssignment has been created using JDBC
		Statement statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT COUNT(*) as total from ProjectAssignment where project_id = " +
				""+projectId+" and employee_id = "+employeeId);
		res.next();
		assertEquals(1, res.getInt("total"));
	}

	@Test
	public void testDeleteProject() throws SQLException {
		// insert a project previously with JDBC
		int projectId = insertAProject();

		// insert an employee previously with JDBC
		int employeeId = insertAnEmployee();

		// assign the employee to the project (which should be removed due to CascadeType.REMOVE
		// in Project.projectAssignments)
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO ProjectAssignment(project_id, employee_id) values("+projectId+", "
				+employeeId+")", Statement
				.RETURN_GENERATED_KEYS);

		EntityManager em = emf.createEntityManager();
		Projects projects = new Projects(em);
		Project p = projects.findById(projectId);

		em.getTransaction().begin();
			projects.deleteProject(p);
		em.getTransaction().commit();

		// ensure that project doesn't exist using JDBC
		statement = jdbcConnection.createStatement();
		ResultSet res = statement.executeQuery("SELECT COUNT(*) as total from Project where id = " +
				""+projectId);
		res.next();
		assertEquals(0, res.getInt("total"));
	}

	@Test
	public void testGetEmployees() throws SQLException {
		// insert a project previously with JDBC
		int projectId = insertAProject();

		// insert an employee previously with JDBC
		int employeeId = insertAnEmployee();

		// assign the employee to the project (which should be removed due to CascadeType.REMOVE
		// in Project.projectAssignments)
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO ProjectAssignment(project_id, employee_id) values("+projectId+", "
				+employeeId+")", Statement
				.RETURN_GENERATED_KEYS);
	}

	private int insertAProject() throws SQLException {
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Project(name) values('our best project')", Statement
				.RETURN_GENERATED_KEYS);
		return getLastInsertedId(statement);
	}

	private int insertAnEmployee() throws SQLException {
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Employee(name) values('pepe')", Statement
				.RETURN_GENERATED_KEYS);
		return getLastInsertedId(statement);
	}
}
