package dgpena.siexample.persistence;

import javax.persistence.EntityManager;

public class Projects {

	private EntityManager em;

	public Projects(EntityManager em) {
		this.em = em;
	}

	public void addNewProject(Project p) {
		em.persist(p);
	}

	public void deleteProject(Project p) {
		// ProjectAssingment related instances are automatically removed due to CascadeType.REMOVE
		em.remove(p);
	}

	public Project findById(int id) {
		return em.find(Project.class, id);
	}

}
