package dgpena.siexample.persistence;

import java.util.List;

import javax.persistence.EntityManager;

public class Employees {

	private EntityManager em;
	
	public Employees(EntityManager em) {
		this.em = em;
	}
	
	public void addNewEmployee(Employee e) {
		this.em.persist(e);
	}

	public Employee findById(int id) {
		return em.find(Employee.class, id);
	}

	public void deleteEmployee(Employee e) {
		// First remove his/her project assignments (in order to preserve database integrity)
		List<ProjectAssignment> projectAssignments = this.em.createQuery("SELECT pa FROM ProjectAssignment pa WHERE " +
				"pa.employee = :e")
				.setParameter("e", e).getResultList();

		for (ProjectAssignment pa: projectAssignments) {
			em.remove(pa);
		}

		this.em.remove(e);
	}
}
