package dgpena.siexample.persistence;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.BeforeClass;
import org.junit.Test;

public class DepartmentsTest extends SQLBasedTest {

	private static EntityManagerFactory emf;
	
	@BeforeClass
	public static void setUpEntityManagerFactory() {
		emf = Persistence.createEntityManagerFactory("si-database");
	}
	

	@Test
	public void testAddNewDepartment() throws Exception {
		
		Department d = new Department();
		d.setName("finanzas");

		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		em.getTransaction().begin();
			depts.addNewDepartment(d);
		em.getTransaction().commit();
		
		// check in the DB using JDBC
		int deptId = d.getId();
		Statement statement = jdbcConnection.createStatement();
		ResultSet rs = statement.executeQuery("SELECT COUNT(*) as total FROM Department d where d.id = "+deptId);
		rs.next();
		assertEquals(1, rs.getInt("total"));
	}
	
	@Test
	public void testFindById() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('finanzas')", Statement.RETURN_GENERATED_KEYS);
		int deptId = getLastInsertedId(statement);

		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		Department d = depts.findById(deptId);
		
		assertEquals(deptId, d.getId());
		assertEquals("finanzas", d.getName());
		
	}
	
	@Test
	public void testUpdateDepartment() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('finanzas')", Statement.RETURN_GENERATED_KEYS);
		int deptId = getLastInsertedId(statement);
		
		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		Department d = depts.findById(deptId);
		
		em.getTransaction().begin();
			d.setName("contabilidad");
		em.getTransaction().commit();
		
		// check in the DB using JDBC
		statement = jdbcConnection.createStatement();
		ResultSet rs = statement.executeQuery("SELECT * FROM Department d where d.id = "+deptId);
		rs.next();
		assertEquals("contabilidad", rs.getString("name"));

	}
	
	@Test
	public void testDeleteDepartment() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('finanzas')", Statement.RETURN_GENERATED_KEYS);
		int deptId = getLastInsertedId(statement);
		
		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		Department d = depts.findById(deptId);
		
		em.getTransaction().begin();
			depts.deleteDepartment(d);
		em.getTransaction().commit();
		
		// check in the DB using JDBC
		statement = jdbcConnection.createStatement();
		ResultSet rs = statement.executeQuery("SELECT COUNT(*) as total FROM Department d where d.id = "+deptId);
		rs.next();
		assertEquals(0, rs.getInt("total"));
	}
	
	@Test
	public void testFindAllDepartments() throws SQLException {
		// insert a department previously with JDBC
		Statement statement = jdbcConnection.createStatement();
		statement.executeUpdate("DELETE FROM Department", Statement.RETURN_GENERATED_KEYS);
		
		statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('dept-1')", Statement.RETURN_GENERATED_KEYS);
		
		statement = jdbcConnection.createStatement();
		statement.executeUpdate("INSERT INTO Department(name) values('dept-2')", Statement.RETURN_GENERATED_KEYS);
		
		EntityManager em = emf.createEntityManager();
		Departments depts = new Departments(em);
		List<Department> departments = depts.findAll();
		
		assertEquals(2, departments.size());
		
		Set<String> namesToTest = new HashSet(Arrays.asList("dept-1", "dept-2"));
		for (Department d: departments) {
			namesToTest.remove(d.getName());
		}
		
		assertTrue(namesToTest.isEmpty());
	}
	
}
