package dgpena.siexample.persistence;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Project {
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private int id;
	
	private String name;
	
	@OneToMany(mappedBy="project", cascade = {CascadeType.REMOVE, CascadeType.PERSIST}, orphanRemoval = true)
	private Set<ProjectAssignment> projectAssignments = new HashSet<>();
	
	public int getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public Set<Employee> getEmployees() {
		Set<Employee> employees = new HashSet<>();
		
		for (ProjectAssignment pa : projectAssignments) {
			employees.add(pa.getEmployee());
		}
		
		return employees;
	}
	
	public void setEmployees(Collection<Employee> employees) {
		// remove my employees that are not in the new list of employees
		for (Employee e: this.getEmployees()) {
			if (!employees.contains(e)) {
				this.removeEmployee(e);
			}
		}
		
		// add all the new employees
		for (Employee e: employees) {
			if (!this.getEmployees().contains(e)) {
				this.addEmployee(e, new Date());
			}
		}
	}

	public void addEmployee(Employee e, Date startDate) {

		ProjectAssignment pa = new ProjectAssignment();
		pa.setProject(this);
		pa.setStartDate(startDate);
		pa.setEmployee(e);
		// the ProjectAssignment is automatically persisted due to CascadeType.PERSIST
	}

	public void removeEmployee(Employee e) {
		for (ProjectAssignment pa: this.projectAssignments) {
			if (pa.getEmployee().equals(e)) {
				// this will call internalRemoveProjectAssignment
				pa.setProject(null);

				// the project assignment will be also removed from the DB due to "orphanRemoval"
			}
		}
	}

	void internalRemoveProjectAssignment(ProjectAssignment projectAssignment) {
		this.projectAssignments.remove(projectAssignment);
	}

	void internalAddProjectAssignment(ProjectAssignment projectAssignment) {
		this.projectAssignments.add(projectAssignment);
	}


	
}
