package dgpena.siexample.persistence;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Department {
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private int id;

	private String name;
	
	@OneToMany(mappedBy="department")
	private Set<Employee> employees = new HashSet<Employee>();
	
	public int getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public Set<Employee> getEmployees() {
		return Collections.unmodifiableSet(employees);
	}
	
	public void addEmployee(Employee e) {
		e.setDepartment(this);
	}
	
	public void removeEmployee(Employee e) {
		e.setDepartment(null);
	}
	
	void internalAddEmployee(Employee e) {
		this.employees.add(e);
	}
	
	void internalRemoveEmployee(Employee e) {
		this.employees.remove(e);
	}
}
