package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	@Test
	public void testPetIntIntStringFloat() {
		final int id = 1;
		final int owner = 1;
		final String name = "Perica";
		final float weight = 2.15f;
		
		final Pet pet = new Pet(id, owner, name, weight);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getWeight(), is(equalTo(weight)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntIntStringFloatNullOwner() {
		new Pet(1, (Integer)null, "Perica", 2.30f);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntIntStringFloatNullName() {
		new Pet(1, 1, null, 2.30f);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntIntStringFloatNullWeight() {
		new Pet(1, 1, "Perica", (Float)null);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int owner = 1;
		final float weight = 2.15f;
		
		final Pet pet = new Pet(id, owner, "Perica", weight);
		pet.setName("Pintitas");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getName(), is(equalTo("Pintitas")));
		assertThat(pet.getWeight(), is(equalTo(weight)));
	}
	
	@Test
	public void testSetWeight() {
		final int id = 1;
		final int owner = 1;
		final String name = "Perica";
		
		final Pet pet = new Pet(id, owner, "Perica", 2.15f);
		pet.setWeight(3.3f);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getWeight(), is(equalTo(3.3f)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, 1, "John", 2.15f);
		
		pet.setName(null);
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullWeight() {
		final Pet pet = new Pet(1, 1, "John", 2.15f);
		
		pet.setWeight((Float)null);
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, 1, "Name A", 2.15f);
		final Pet petB = new Pet(1, 1, "Name B", 3.65f);
		
		assertTrue(petA.equals(petB));
	}
	
	
	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("owner", "name", "weight")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS).verify();
	}
	
}
