var PetsView = (function() {
	var dao;
	var owner;
        var people;
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
	
	var formId = 'pets-form';
	var listId = 'pets-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetsView(petsDao, formContainerId, listContainerId) {
		dao = petsDao;
		self = this;

		this.init = function(peopleView, person) {
                        people = peopleView;
                        owner = person;
                        
                        insertPetForm($('#' + formContainerId));
                        insertPetList($('#' + listContainerId));
                        
			dao.listPetsWithOwner(owner.id, function(pets) {
				$.each(pets, function(key, pet) {
                                        appendToTable(pet);
				});
			},
			function() {
			    	alert('No has sido posible acceder al listado de mascotas.');
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var pet = self.getPetInForm();
				
				if (self.isEditing()) {
					dao.modifyPet(pet,
						function(pet) {
                                                        $('#pet-' + pet.id + ' td.owner').text(pet.owner);
							$('#pet-' + pet.id + ' td.name').text(pet.name);
							$('#pet-' + pet.id + ' td.weight').text(pet.weight);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPet(pet,
						function(pet) {
                                                        
							appendToTable(pet);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
                        
			$('#btnClear').click(this.resetForm);
                        $('#btnReturn').click(returnToPeople);
                        
                        
                        
		};

		this.getPetInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
                                'owner': owner.id,
				'name': form.find('input[name="name"]').val(),
				'weight': form.find('input[name="weight"]').val()
			};
		};

		this.getPetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
                                        'owner': owner.id,
					'name': row.find('td.name').text(),
					'surname': row.find('td.weight').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editPet = function(id,owner) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				var form = $(formQuery);
				
				form.find('input[name="id"]').val(id);
                                form.find('input[name="owner"]').val(owner);
				form.find('input[name="name"]').val(row.find('td.name').text());
				form.find('input[name="weight"]').val(row.find('td.weight').text());
				
				$('input#btnSubmit').val('Modificar');
			}
		};
		
		this.deletePet = function(id) {
			if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
				dao.deletePet(id,
					function() {
						$('tr#pet-' + id).remove();
					},
					showErrorMessage
				);
			}
		};

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
                
        this.detachForms = function() {
            $(formQuery).remove();
			$(listQuery).remove();
            $('#titulo').text('Personas');
		};     
                
	};

	
	var insertPetList = function(parent) {
		parent.append(
			'<table id="' + listId + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col-sm-4">Nombre Mascota</th>\
						<th class="col-sm-5">Peso</th>\
						<th class="col-sm-3">&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};

	var insertPetForm = function(parent) {
		parent.append(
			'<form id="' + formId + '" class="mb-5 mb-10">\
				<input name="id" type="hidden" value=""/>\
                                <input name="owner" type="hidden" value="' + owner + '"/>\
				<div class="row">\
					<div class="col-sm-4">\
						<input name="name" type="text" value="" placeholder="Nombre Mascota" class="form-control" required/>\
					</div>\
					<div class="col-sm-4">\
						<input name="weight" type="text" value="" placeholder="Peso" class="form-control" required/>\
					</div>\
					<div class="col-sm-4">\
						<input id="btnSubmit" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClear" type="reset" value="Limpiar" class="btn" />\
                                                <input id="btnReturn" type="button" value="Volver" class="btn btn-dark" />\
					</div>\
				</div>\
			</form>'
		);
	};

	var createPetRow = function(pet) {
		return '<tr id="pet-'+ pet.id +'" class="row">\
			<td class="name col-sm-4">' + pet.name + '</td>\
			<td class="weight col-sm-5">' + pet.weight + '</td>\
			<td class="col-sm-3">\
				<a class="edit btn btn-primary" href="#">Editar</a>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
			</td>\
		</tr>';
	};

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	};

	var addRowListeners = function(pet) {
		$('#pet-' + pet.id + ' a.edit').click(function() {
			self.editPet(pet.id, pet.owner);
		});
		
		$('#pet-' + pet.id + ' a.delete').click(function() {
			self.deletePet(pet.id);
		});

	};

	var appendToTable = function(pet) {
		$(listQuery + ' > tbody:last')
			.append(createPetRow(pet));
		addRowListeners(pet);
	};
        
        var returnToPeople = function() {
		self.detachForms();
                people.init();
	};
	
	return PetsView;
})();
