package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetsDataset {
	private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, 4, "Pintitas", 5.15f),
			new Pet(2, 1, "Yami", 3.15f),
			new Pet(3, 2, "Kirara", 4.45f),
			new Pet(4, 2, "Pelusa", 6.7f),
			new Pet(5, 1, "Cotufo", 3.2f)
		};
	}
	
	public static Pet[] petsToListWithOwnerIdTest() {
		return new Pet[] {
			new Pet(2, 1, "Yami", 3.15f),
			new Pet(5, 1, "Cotufo", 3.2f)
		};
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int existentOwnerId() {
		return 1;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), 2, "Luna", 3.57f);
	}
	
	public static int newOwner() {
		return 1;
	}
	
	public static String newName() {
		return "Sol";
	}
	
	public static Float newWeight() {
		return 6f;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newOwner(), newName(), newWeight());
	}
}
