package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {
	private int id;
	private int owner;
	private String name;
	private float weight;
	
	
	// Constructor needed for the JSON conversion
	Pet() {}
	
		
	/**
	 * Constructs a new instance of {@link Pet}.
	 *
	 * @param id identifier of the pet.
	 * @param owner owner of the pet.
	 * @param name name of the pet.
	 * @param weight weight of the pet.
	 */
	public Pet(int id, int owner, String name, float weight) {
		this.id = id;
		this.owner = owner;
		this.setName(name);
		this.setWeight(weight);
	}


	/**
	 * Returns the identifier of the pet.
	 * 
	 * @return the identifier of the pet.
	 */
	public int getId() {
		return id;
	}

	
	/**
	 * Returns the owner of the pet.
	 * 
	 * @return the owner of the pet.
	 */
	public int getOwner() {
		return owner;
	}
	
	
	/**
	 * Returns the name of the pet.
	 * 
	 * @return the name of the pet.
	 */
	public String getName() {
		return name;
	}
	
	
	/**
	 * Set the name of this pet.
	 * 
	 * @param name the new name of the pet.
	 * @throws NullPointerException if the {@code name} is {@code null}.
	 */
	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}
	
	
	/**
	 * Returns the weight of the pet.
	 * 
	 * @return the weight of the pet.
	 */
	public float getWeight() {
		return weight;
	}
	
	
	/**
	 * Set the weight of this pet.
	 * 
	 * @param weight the new weight of the pet.
	 * @throws NullPointerException if the {@code weight} is {@code null}.
	 */
	public void setWeight(float weight) {
		this.weight = requireNonNull(weight, "Weight can't be null");
	}
	
	
	@Override
	public int hashCode() {
		final int prime = 37;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
	
	
	
}
