/**
 *  Temario DAI
 *  Copyright (C) 2014 Miguel Reboiro-Jato
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package es.uvigo.esei.dai.xml.tests;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import es.uvigo.esei.dai.xml.dom.DOMParsing;
import es.uvigo.esei.dai.xml.sax.SAXParsing;

public class Tests {
  public static void main(String[] args) {
    // final File dtdFile = new File("libros.dtd");
    final File xsdFile = new File("libros.xsd");
    final File xmlFile = new File("libros.xml");
    final File xmlXsdFile = new File("libros.xsd.xml");
    final File xmlDtdFile = new File("libros.dtd.xml");
    final File xmlBadFile = new File("libros.bad.xml");
    final File xmlBadXsdFile = new File("libros.xsd.bad.xml");
    final File xmlBadDtdFile = new File("libros.dtd.bad.xml");
    final File xmlTrainFile = new File("trenes.xml");

    System.out.println("======== DOM ========");
    try {
      DOMParsing.loadAndValidateWithInternalDTD(xmlDtdFile.getAbsolutePath());
      System.out.println("Good: OK loadAndValidateWithInternalDTD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception loadAndValidateWithInternalDTD");
    }

    try {
      DOMParsing.loadAndValidateWithInternalXSD(xmlXsdFile.getAbsolutePath());
      System.out.println("Good: OK loadAndValidateWithInternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception loadAndValidateWithInternalXSD");
    }

    try {
      DOMParsing.loadAndValidateWithExternalXSD(xmlFile.getAbsolutePath(), xsdFile.getAbsolutePath());
      System.out.println("Good: OK loadAndValidateWithExternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception loadAndValidateWithExternalXSD");
    }

    try {
      DOMParsing.loadAndValidateWithInternalDTD(xmlBadDtdFile.getAbsolutePath());
      System.out.println("Bad: OK loadAndValidateWithInternalDTD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception loadAndValidateWithInternalDTD");
    }

    try {
      DOMParsing.loadAndValidateWithInternalXSD(xmlBadXsdFile.getAbsolutePath());
      System.out.println("Bad: OK loadAndValidateWithInternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception loadAndValidateWithInternalXSD");
    }

    try {
      DOMParsing.loadAndValidateWithExternalXSD(xmlBadFile.getAbsolutePath(), xsdFile.getAbsolutePath());
      System.out.println("Bad: OK loadAndValidateWithExternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception loadAndValidateWithExternalXSD");
    }

    try {
      final Document trains = DOMParsing.loadAndValidateWithInternalXSD(xmlTrainFile.getAbsolutePath());

      System.out.println("Trains: List of trains [DOM]");
      final NodeList trainNodes = trains.getElementsByTagName("tren");

      for (int i = 0; i < trainNodes.getLength(); i++) {
        if (trainNodes.item(i) instanceof Element) {
          final Element trainElement = (Element) trainNodes.item(i);
          final Node salidaNode = trainElement.getElementsByTagName("salida").item(0);
          final Node llegadaNode = trainElement.getElementsByTagName("llegada").item(0);

          System.out.print(trainElement.getAttribute("ruta"));
          System.out.print(" - ");
          System.out.print(salidaNode.getTextContent());
          System.out.print(" | ");
          System.out.println(llegadaNode.getTextContent());
        }
      }
    } catch (ParserConfigurationException | SAXException | IOException e1) {
      e1.printStackTrace();
      System.out.println("Trains: Exception");
    }

    System.out.println("\n======== SAX ========");
    try {
      SAXParsing.parseAndValidatedWithInternalDTD(xmlDtdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Good: OK parseAndValidatedWithInternalDTD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception parseAndValidatedWithInternalDTD");
    }

    try {
      SAXParsing.parseAndValidateWithInternalXSD(xmlXsdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Good: OK parseAndValidateWithInternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception parseAndValidateWithInternalXSD");
    }

    try {
      SAXParsing
        .parseAndValidateWithExternalXSD(xmlFile.getAbsolutePath(), xsdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Good: OK parseAndValidateWithExternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Good: Exception parseAndValidateWithExternalXSD");
    }

    try {
      SAXParsing.parseAndValidatedWithInternalDTD(xmlBadDtdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Bad: OK parseAndValidatedWithInternalDTD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception parseAndValidatedWithInternalDTD");
    }

    try {
      SAXParsing.parseAndValidateWithInternalXSD(xmlBadXsdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Bad: OK parseAndValidateWithInternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception parseAndValidateWithInternalXSD");
    }

    try {
      SAXParsing
        .parseAndValidateWithExternalXSD(xmlBadFile.getAbsolutePath(), xsdFile.getAbsolutePath(), new DefaultHandler());
      System.out.println("Bad: OK parseAndValidateWithExternalXSD");
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Bad: Exception parseAndValidateWithExternalXSD");
    }

    try {
      final TrenesContentHandler contentHandler = new TrenesContentHandler();
      SAXParsing.parseAndValidateWithInternalXSD(xmlTrainFile.getAbsolutePath(), contentHandler);

      System.out.println("Trains: List of trains [SAX]");
      for (final Tren tren : contentHandler.getTrenes()) {
        System.out.println(tren);
      }
    } catch (ParserConfigurationException | SAXException | IOException e) {
      System.out.println("Trains: Exception");
    }
  }
}
