package es.uvigo.esei.dai.xml.tests;

import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TrenesContentHandler extends DefaultHandler {
  private List<Tren> trenes;
  private Tren tren;
  private Date lastDate;

  public List<Tren> getTrenes() {
    return trenes;
  }

  @Override
  public void startDocument() throws SAXException {
    this.trenes = new LinkedList<>();
  }

  @Override
  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    if ("tren".equals(localName)) {
      this.tren = new Tren();
      this.tren.setRuta(attributes.getValue("ruta"));
    }
  }

  @Override
  public void characters(char[] ch, int start, int length) throws SAXException {
    final String textContent = new String(ch, start, length);

    if (!textContent.trim().isEmpty()) {
      try {
        this.lastDate = Tren.DATE_FORMAT.parse(textContent);
      } catch (final ParseException pe) {
        throw new SAXException("Invalid date: " + textContent, pe);
      }
    }
  }

  @Override
  public void endElement(String uri, String localName, String qName) throws SAXException {
    if ("tren".equals(localName)) {
      this.trenes.add(this.tren);
      this.tren = null;
    } else if ("salida".equals(localName)) {
      this.tren.setSalida(this.lastDate);
      this.lastDate = null;
    } else if ("llegada".equals(localName)) {
      this.tren.setLlegada(this.lastDate);
      this.lastDate = null;
    }
  }
}
