package es.uvigo.esei.dai.xml.tests;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Tren {
  public final static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

  private String ruta;
  private Date salida;
  private Date llegada;

  public Tren() {
  }

  public Tren(String ruta, Date salida, Date llegada) {
    this.ruta = ruta;
    this.salida = salida;
    this.llegada = llegada;
  }

  public String getRuta() {
    return ruta;
  }

  public void setRuta(String ruta) {
    this.ruta = ruta;
  }

  public Date getSalida() {
    return salida;
  }

  public void setSalida(Date salida) {
    this.salida = salida;
  }

  public Date getLlegada() {
    return llegada;
  }

  public void setLlegada(Date llegada) {
    this.llegada = llegada;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + (llegada == null ? 0 : llegada.hashCode());
    result = prime * result + (ruta == null ? 0 : ruta.hashCode());
    result = prime * result + (salida == null ? 0 : salida.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if ((obj == null) || (getClass() != obj.getClass())) {
      return false;
    }
    final Tren other = (Tren) obj;
    if (llegada == null) {
      if (other.llegada != null) {
        return false;
      }
    } else if (!llegada.equals(other.llegada)) {
      return false;
    }
    if (ruta == null) {
      if (other.ruta != null) {
        return false;
      }
    } else if (!ruta.equals(other.ruta)) {
      return false;
    }
    if (salida == null) {
      if (other.salida != null) {
        return false;
      }
    } else if (!salida.equals(other.salida)) {
      return false;
    }
    return true;
  }

  @Override
  public String toString() {
    return String.format("%s - %s | %s", this.getRuta(), DATE_FORMAT.format(this.getSalida()), DATE_FORMAT.format(this.getLlegada()));
  }
}
