<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:l="http://www.esei.uvigo.es/dai/libros">
	
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE HTML&gt;</xsl:text>
		<html>
			<head>
				<title>Libros</title>
			</head>
			<body>
				<h1>Lista de Libros</h1>
				<xsl:apply-templates select="l:libros/l:libro"/>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="l:libro">
		<div>
			<h2><xsl:value-of select="@titulo"/></h2>
			<ol>
				<xsl:for-each select="l:capitulo">
					<xsl:sort select="@numero"/>
					
					<li><xsl:value-of select="."/></li>
				</xsl:for-each>
			</ol>
		</div>
	</xsl:template>
</xsl:stylesheet>

