/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import jakarta.xml.ws.Service;

public class CalculatorServiceClient {
	public static void main(String[] args) throws MalformedURLException {
		final URL url = new URL("http://localhost:9876/calculator?wsdl");
		
		final QName name = new QName(
			"http://calculator.ws.dai.esei.uvigo.es/",
			"CalculatorServiceImplService"
		);
		
		final Service service = Service.create(url, name);
		
		final CalculatorService calculator = service.getPort(CalculatorService.class);
		
		System.out.println(calculator.add(20d, 30d));
		System.out.println(calculator.subtract(20d, 30d));
		System.out.println(calculator.multiply(20d, 0d));
		System.out.println(calculator.divide(20d, 30d));
		try {
			System.out.println(calculator.divide(20d, 0d));
		} catch (CalculatorException e) {
			e.printStackTrace();
		}
	}
}
