/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedResultsMap {
	private List<NamedResultsEntry> entries;
	
	public NamedResultsMap() {
		this.entries = new LinkedList<NamedResultsEntry>();
	}

	public NamedResultsMap(Map<String, Double> map) {
		this();
		
		for (Map.Entry<String, Double> entry : map.entrySet()) {
			this.entries.add(new NamedResultsEntry(entry));
		}
	}
	
	public Map<String, Double> createMap() {
		final Map<String, Double> map = new HashMap<String, Double>();
		
		for (NamedResultsEntry entry : this.entries) {
			map.put(entry.getKey(), entry.getValue());
		}
		
		return map;
	}

	public List<NamedResultsEntry> getEntries() {
		return entries;
	}

	public void setEntries(List<NamedResultsEntry> entries) {
		this.entries = entries;
	}
}
