/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.Map;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class NamedResults {
	private Map<String, Double> results;

	public NamedResults() {
		this.results = new HashMap<String, Double>();
	}
	
	public NamedResults(Map<String, Double> results) {
		this.results = results;
	}

	@XmlJavaTypeAdapter(NamedResultsMapAdapter.class)
	public Map<String, Double> getResults() {
		return results;
	}

	public void setResults(Map<String, Double> results) {
		this.results = results;
	}
}
