/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.Operation;

public class NamedOperationsEntry {
	private String key;
	private Operation value;
	
	public NamedOperationsEntry() {
	}
	
	public NamedOperationsEntry(String key, Operation value) {
		this.key = key;
		this.value = value;
	}

	public NamedOperationsEntry(Map.Entry<String, Operation> entry) {
		this(entry.getKey(), entry.getValue());
	}

	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	public Operation getValue() {
		return value;
	}
	
	public void setValue(Operation value) {
		this.value = value;
	}
}
