/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.Operation;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class NamedOperations {
	private Map<String, Operation> operations;

	public NamedOperations() {
		this.operations = new HashMap<String, Operation>();
	}
	
	public NamedOperations(Map<String, Operation> operations) {
		super();
		this.operations = operations;
	}

	@XmlJavaTypeAdapter(NamedOperationsMapAdapter.class)
	public Map<String, Operation> getOperations() {
		return operations;
	}

	public void setOperations(Map<String, Operation> operations) {
		this.operations = operations;
	}
}
