/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator;

import java.util.concurrent.Executors;

import jakarta.xml.ws.Endpoint;

public class CalculatorServer {
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		final Endpoint endpoint = Endpoint.publish(
			"http://localhost:9876/calculator", 
			new CalculatorServiceImpl()
		);
		
		endpoint.setExecutor(
			Executors.newFixedThreadPool(20)
		);
	}
}
