/*-
 * #%L
 * Ejemplos de DAI - Multithilo
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.threads;

import java.io.IOException;
import java.net.Socket;

public class ServiceThread implements Runnable {
  private final Socket socket;

  public ServiceThread(Socket clientSocket) throws IOException {
    this.socket = clientSocket;
  }

  @Override
  public void run() {
    try (this.socket) {
      final SocketIOManager ioManager = new SocketIOManager(this.socket);

      String message;
      while (!(message = ioManager.readLine()).equalsIgnoreCase("quit")) {
        ioManager.println(message.toUpperCase());
      }
    } catch (final IOException e) {
      e.printStackTrace();
    }
  }
}
