/*-
 * #%L
 * Ejemplos de DAI - Multithilo
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.threads.example3;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import es.uvigo.esei.dai.threads.ServiceThread;

public class ThreadPoolEchoServer {
  public static void main(String[] args) {
    try (ServerSocket serverSocket = new ServerSocket(50000)) {
      final ExecutorService threadPool = Executors.newFixedThreadPool(50);

      while (true) {
        final Socket clientSocket = serverSocket.accept();

        threadPool.execute(new ServiceThread(clientSocket));
      }
    } catch (final IOException e) {
      System.err.println("Server socket could not be created");
    }
  }
}
