/*-
 * #%L
 * Ejemplos de DAI - Multithilo
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.threads.example0;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

import es.uvigo.esei.dai.threads.SocketIOManager;

public class EchoServer {
  public static void main(String[] args) {
    try (ServerSocket serverSocket = new ServerSocket(50000)) {

      // Bucle principal:
      // 1. Aceptación de la conexión
      // 2. Recepción de mensajes
      // 3. Respuesta a los mensajes

      while (true) {
        // 1. Aceptación de la conexión
        try (Socket clientSocket = serverSocket.accept()) {
          try {
            final SocketIOManager manager = new SocketIOManager(clientSocket);

            String message;
            // 2. Recepción de mensajes
            while (!(message = manager.readLine()).equalsIgnoreCase("quit")) {
              manager.println(message.toUpperCase()); // 3. Respuesta
            }
          } catch (final IOException ioe) {
            System.err.println("Connection error: " + ioe.getMessage());
          }
        }
      }
    } catch (final IOException e) {
      System.err.println("Server socket could not be created: " + e.getMessage());
    }
  }
}
