/*-
 * #%L
 * Ejemplos de DAI - Multithilo
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.threads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class SocketIOManager implements IOManager {
  private final Socket socket;
  private final BufferedReader reader;
  private final PrintWriter writer;

  public SocketIOManager(Socket socket) throws IOException {
    this.socket = socket;

    this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    this.writer = new PrintWriter(socket.getOutputStream());
  }

  public Socket getSocket() {
    return this.socket;
  }

  @Override
  public boolean canRead() throws IOException {
    return !this.socket.isClosed() && this.socket.getInputStream().available() > 0;
  }

  @Override
  public void println(String line) throws IOException {
    this.writer.println(line);
    this.writer.flush();
  }

  @Override
  public String readLine() throws IOException {
    return this.reader.readLine();
  }
}
