/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3.controller;

import java.util.List;

import es.uvigo.esei.dai.kata3.EmployeeNotFoundException;
import es.uvigo.esei.dai.kata3.SearchType;
import es.uvigo.esei.dai.kata3.model.dao.EmployeesDAO;
import es.uvigo.esei.dai.kata3.model.entity.Employee;

public class DefaultEmployeesController implements EmployeesController {
  private final EmployeesDAO dao;

  public DefaultEmployeesController(EmployeesDAO dao) {
    this.dao = dao;
  }

  @Override
  public Employee get(int id) throws EmployeeNotFoundException {
    return this.dao.get(id);
  }

  @Override
  public void create(Employee employee) {
    this.dao.create(employee);
  }

  @Override
  public void update(Employee employee) throws EmployeeNotFoundException {
    this.dao.update(employee);
  }

  @Override
  public void delete(int id) throws EmployeeNotFoundException {
    this.dao.delete(id);
  }

  @Override
  public List<Employee> list() {
    return this.dao.list();
  }

  @Override
  public List<Employee> list(SearchType type, String value) throws IllegalArgumentException {
    switch (type) {
    case NAME:
      return this.dao.listByName(value);
    case SURNAME:
      return this.dao.listBySurname(value);
    case SALARY:
      try {
        return this.dao.listBySalary(Integer.parseInt(value));
      } catch (NumberFormatException nfe) {
        throw new IllegalArgumentException(nfe);
      }
    default:
      throw new IllegalArgumentException("Unknown type: " + type);
    }
  }
}
