/*-
 * #%L
 * Ejemplos de DAI - Sockets
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.sockets.example4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class MessageReceiver {
  public static void main(String[] args) {
    try (DatagramSocket socket = new DatagramSocket(60000)) {
      final byte[] buffer = new byte[1500];

      while (true) {
        final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);

        socket.receive(packet);

        try {
          final ByteArrayInputStream input = new ByteArrayInputStream(buffer);
          final ObjectInputStream dataInput = new ObjectInputStream(input);

          final Message message = (Message) dataInput.readObject();

          System.out.println("SUBJECT: " + message.getSubject());
          System.out.println("MESSAGE: " + message.getMessage());
        } catch (final ClassNotFoundException e) {
          e.printStackTrace();
        }
      }
    } catch (final IOException e) {
      System.out.println("Connection error: ");
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
  }
}
