<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:r="http://www.ei.uvigo.es/dai/recetas"
>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="/" >
		<html>
			<head>
				<title>Recetario</title>
				<link rel="stylesheet" href="http://code.jquery.com/ui/1.10.3/themes/south-street/jquery-ui.css" />
				<link rel="stylesheet" href="recetas.css" />
			    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
			    <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
			    <script src="recetas.js"></script>
			</head>
			<body>
				<div id="container">
					<h1>Recetario</h1>
					<div id="recetas">
						<xsl:apply-templates select="r:recetas/r:receta"/>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="r:autores">
		<div class="autores">
			<h4>Autores</h4>
			<ul>
				<xsl:for-each select="r:autor">
					<li><xsl:value-of select="id(@id)"/></li>
				</xsl:for-each>
			</ul>
		</div>
	</xsl:template>
	
	<xsl:template match="r:receta">
		<h3><xsl:value-of select="r:titulo"/></h3>
		<div>
			<div class="info">
				<div class="dificultad">
					<strong>Dificultad:</strong>&#160;<xsl:value-of select="@dificultad"/>
				</div>
				<div class="comensales">
					<strong>Comensales:</strong>&#160;<xsl:value-of select="@personas"/>
				</div>
				<div class="tiempo">
					<strong>Tiempo:</strong>&#160;<xsl:value-of select="@tiempo"/> mins.
				</div>
			</div>
			<xsl:if test="r:autores">
				<xsl:apply-templates select="r:autores"/>
			</xsl:if>
			<xsl:if test="r:descripcion">
				<div class="descripcion">
					<xsl:value-of select="r:descripcion" disable-output-escaping="yes"/>
				</div>
			</xsl:if>
			<div class="ingredientes">
				<h4>Ingredientes</h4>
				<ul>
					<xsl:for-each select="r:ingredientes/r:ingrediente">
						<li>
							<xsl:value-of select="@nombre"/>
							[<xsl:value-of select="@cantidad"/>&#160;<xsl:value-of select="@medida"/>]
						</li>
					</xsl:for-each>
				</ul>
			</div>
			<div class="pasos">
				<h4>Pasos</h4>
				<dl>
					<xsl:for-each select="r:pasos/r:paso">
						<xsl:sort select="@orden" order="ascending" data-type="number"/>
						<dt>
							Paso <xsl:value-of select="@orden"/>. <xsl:value-of select="@accion"/>
						</dt>
						<dd>
							<xsl:value-of select="."/>
						</dd>
					</xsl:for-each>
				</dl>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>