/*-
 * #%L
 * DAI Dojo - Kata 6
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.xml.xpath;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;

public class NamespaceContextMap implements NamespaceContext {
  private final Map<String, String> namespaceToPrefix;
  private final Map<String, String> prefixToNamespace;

  public NamespaceContextMap() {
    this.namespaceToPrefix = new HashMap<>();
    this.prefixToNamespace = new HashMap<>();
  }

  public void putNamespaceURI(String prefix, String namespaceURI) {
    this.namespaceToPrefix.put(namespaceURI, prefix);
    this.prefixToNamespace.put(prefix, namespaceURI);
  }

  @Override
  public String getNamespaceURI(String prefix) {
    return this.prefixToNamespace.get(prefix);
  }

  @Override
  public String getPrefix(String namespaceURI) {
    return this.namespaceToPrefix.get(namespaceURI);
  }

  @Override
  public Iterator<String> getPrefixes(String namespaceURI) {
    return this.namespaceToPrefix.keySet().iterator();
  }
}
