/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import es.uvigo.esei.dai.kata3.controller.DefaultEmployeesController;
import es.uvigo.esei.dai.kata3.controller.EmployeesController;
import es.uvigo.esei.dai.kata3.model.dao.EmployeesDAO;
import es.uvigo.esei.dai.kata3.model.dao.EmployeesMapDAO;
import es.uvigo.esei.dai.kata3.view.EmployeesPanel;

public class Launch {
  public static void main(String[] args) throws SQLException {
    // Una vez completado el ejercicio cambiar el DAO creado
    final EmployeesDAO dao = new EmployeesMapDAO();
    // final EmployeesDAO dao = createEmployeesJavaDBDAO(false);
    // final EmployeesDAO dao = createEmployeesMySQLDBDAO();

    final EmployeesController controller = new DefaultEmployeesController(dao);

    SwingUtilities.invokeLater(() -> {
      changeLookAndFeelToNimbus();

      final JFrame frame = new JFrame("Employees Manager");
      frame.setContentPane(new EmployeesPanel(controller));

      frame.setSize(800, 600);
      frame.setLocationRelativeTo(null);
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);
    });
  }

  /* Una vez completado el ejercicio descomentar este bloque de código.
  private final static EmployeesDAO createEmployeesJavaDBDAO(boolean createDatabase) throws SQLException {
    final Connection connection;

    // La base de datos ya debería estar creada
    if (createDatabase) {
      connection = DriverManager.getConnection("jdbc:derby:db/employees;create=true", "kata3", "kata3");
      createJavaDBDatabase(connection);
    } else {
      connection = DriverManager.getConnection("jdbc:derby:db/employees", "kata3", "kata3");
    }

    return new EmployeesDBDAO(connection);
  }

  private final static void createJavaDBDatabase(Connection connection) throws SQLException {
    connection.createStatement().execute("CREATE SCHEMA KATA3");
    connection.createStatement().execute(
      "CREATE TABLE Employees "
        + "(id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), "
        + "name VARCHAR(100) NOT NULL, "
        + "surname VARCHAR(100) NOT NULL, "
        + "birth DATE NOT NULL, "
        + "salary INTEGER NOT NULL, "
        + "intern BOOLEAN NOT NULL,  PRIMARY KEY (id)"
        + ")"
    );
  }

  private final static EmployeesDAO createEmployeesMySQLDBDAO() throws SQLException {
    final Connection connection = DriverManager
      .getConnection("jdbc:mysql://localhost:3306/employees", "kata3", "kata3");

    return new EmployeesDBDAO(connection);
  }*/

  private static void changeLookAndFeelToNimbus() {
    try {
      for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
        if ("Nimbus".equals(info.getName())) {
          UIManager.setLookAndFeel(info.getClassName());
          break;
        }
      }
    } catch (Exception e) {
      // If Nimbus is not available, you can set the GUI to another
      // look and feel.
    }
  }
}
