# Kata 3: JDBC

En esta Kata utilizaremos JDBC para trabajar con una base de datos, partiendo del siguiente proyecto base: https://sing-group.org/dt/gitlab/dai-2324/kata3-base

Este  proyecto contiene un sistema funcional para la gestión de datos de usuarios. El único problema de este sistema es que el almacenamiento de datos realizado por la clase `EmployeesMapDAO` se realiza en memoria, con lo que el sistema no resulta realmente útil.

El objetivo de esta Kata será sustituir la clase `EmployeesMapDAO` por otra llamada `EmployeesDBDAO` que almacene los datos en una base de datos a través de JDBC.

Aunque al principio del Kata se explicará brevemente la estructura del programa, tan solo será necesario crear y editar la clase `EmployeesDBDAO`. Por lo tanto, no será necesario modificar ninguna otra clase, con la excepción de la clase `Launcher` (ver indicaciones en la misma clase) una vez completada la clase `EmployeesDBDAO`.

## Notas

1. La aplicación se puede ejecutar lanzando la clase `es.uvigo.esei.dai.kata3.Launch` o, simplemente, ejecutando el comando `mvn exec:java` desde la raíz del proyecto.

2. Cuando se haya completado la Kata se probará contra dos bases de datos:

   * **JavaDB** / **Derby**: es un SGBD ligero y embebible, diseñado, principalmente, para pruebas. En el proyecto tendrás una base de datos Derby en el directorio `db` y las consultas de creación de las tablas en `sql/employees.javadb.sql`. En principio, no debería ser necesario que las ejecutes manualmente, puesto que la tabla ya debería estar creada en la base de datos.

   * **MySQL**: en el fichero `sql/employees.mysql.sql` están las consultas necesarias para crear las base de datos. La base de datos se llamará `employees` y debe tener acceso a ella el usuario `kata3` con password `kata3`.


