package es.uvigo.esei.dai.ws.calculator;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import jakarta.xml.ws.Service;

public class CalculatorServiceClient {
	public static void main(String[] args) throws MalformedURLException {
		final URL url = new URL("http://localhost:9876/calculator?wsdl");
		
		final QName name = new QName(
			"http://calculator.ws.dai.esei.uvigo.es/",
			"CalculatorServiceImplService"
		);
		
		final Service service = Service.create(url, name);
		
		final CalculatorService calculator = service.getPort(CalculatorService.class);
		
		System.out.println(calculator.add(20d, 30d));
		System.out.println(calculator.subtract(20d, 30d));
		System.out.println(calculator.multiply(20d, 0d));
		System.out.println(calculator.divide(20d, 30d));
		try {
			System.out.println(calculator.divide(20d, 0d));
		} catch (CalculatorException e) {
			e.printStackTrace();
		}
	}
}
