package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedResultsMap {
	private List<NamedResultsEntry> entries;
	
	public NamedResultsMap() {
		this.entries = new LinkedList<NamedResultsEntry>();
	}

	public NamedResultsMap(Map<String, Double> map) {
		this();
		
		for (Map.Entry<String, Double> entry : map.entrySet()) {
			this.entries.add(new NamedResultsEntry(entry));
		}
	}
	
	public Map<String, Double> createMap() {
		final Map<String, Double> map = new HashMap<String, Double>();
		
		for (NamedResultsEntry entry : this.entries) {
			map.put(entry.getKey(), entry.getValue());
		}
		
		return map;
	}

	public List<NamedResultsEntry> getEntries() {
		return entries;
	}

	public void setEntries(List<NamedResultsEntry> entries) {
		this.entries = entries;
	}
}
