package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.Operation;

public class NamedOperationsMap {
	private List<NamedOperationsEntry> entries;
	
	public NamedOperationsMap() {
		this.entries = new LinkedList<NamedOperationsEntry>();
	}

	public NamedOperationsMap(Map<String, Operation> map) {
		this();
		
		for (Map.Entry<String, Operation> entry : map.entrySet()) {
			this.entries.add(new NamedOperationsEntry(entry));
		}
	}
	
	public Map<String, Operation> createMap() {
		final Map<String, Operation> map = new HashMap<String, Operation>();
		
		for (NamedOperationsEntry entry : this.entries) {
			map.put(entry.getKey(), entry.getValue());
		}
		
		return map;
	}

	public List<NamedOperationsEntry> getEntries() {
		return entries;
	}

	public void setEntries(List<NamedOperationsEntry> entries) {
		this.entries = entries;
	}
}
