package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.Operation;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class NamedOperations {
	private Map<String, Operation> operations;

	public NamedOperations() {
		this.operations = new HashMap<String, Operation>();
	}
	
	public NamedOperations(Map<String, Operation> operations) {
		super();
		this.operations = operations;
	}

	@XmlJavaTypeAdapter(NamedOperationsMapAdapter.class)
	public Map<String, Operation> getOperations() {
		return operations;
	}

	public void setOperations(Map<String, Operation> operations) {
		this.operations = operations;
	}
}
