package es.uvigo.esei.dai.ws.calculator;

public enum Operation {
	ADD, SUB, MUL, DIV;
	
	public double calculate(double op1, double op2)
	throws CalculatorException {
		switch(this) {
		case ADD: return op1 + op2;
		case SUB: return op1 - op2;
		case MUL: return op1 * op2;
		case DIV: 
			if (op2 == 0d) {
				throw new CalculatorException(
					"op2 can't be zero", "op2 can't be zero"
				);
			} else {
				return op1 / op2;
			}
		default:
			throw new CalculatorException(
				"Unknown operation: " + this,
				"Unknown operation: " + this
			);
		}
	}
}
