package es.uvigo.esei.dai.ws.calculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.adapters.NamedOperations;
import es.uvigo.esei.dai.ws.calculator.adapters.NamedResults;
import jakarta.jws.WebService;

@WebService(endpointInterface = "es.uvigo.esei.dai.ws.calculator.CalculatorService")
public class CalculatorServiceImpl implements CalculatorService {
	@Override
	public double add(double op1, double op2) {
		return this.operate(Operation.ADD, op1, op2);
	}

	@Override
	public double subtract(double op1, double op2) {
		return this.operate(Operation.SUB, op1, op2);
	}

	@Override
	public double multiply(double op1, double op2) {
		return this.operate(Operation.MUL, op1, op2);
	}

	@Override
	public double divide(double op1, double op2) throws CalculatorException {
		return this.operate(Operation.DIV, op1, op2);
	}

	@Override
	public double operate(Operation operation, double op1, double op2)
	throws CalculatorException {
		return operation.calculate(op1, op2);
	}

	@Override
	public double serialOperate(Operation operation, double ... op)
	throws CalculatorException {
		if (op.length <= 1) {
			throw new CalculatorException("There must be, at least, two operands");
		} else {
			double result = op[0];
			
			for (int i = 1; i < op.length; i++) {
				result = operation.calculate(result, op[i]);
			}
			
			return result;
		}
	}

	@Override
	public double arrayOperate(Operation operation, double[] op)
	throws CalculatorException {
		return this.serialOperate(operation, op);
	}

	@Override
	public double listOperate(Operation operation, Collection<Double> op)
	throws CalculatorException {
		if (op.size() <= 1) {
			throw new CalculatorException("There must be, at least, two operands");
		} else {
			final List<Double> values = new ArrayList<Double>(op);
			double result = values.get(0);
			
			for (int i = 1; i < op.size(); i++) {
				result = operation.calculate(result, values.get(i));
			}
			
			return result;
		}
	}

	/*
	 * Ejemplo de implementación para declaración no válida de "mapOperate"
	 * 
	 * @Override
	 * public Map<String, Double> mapOperate(
	 * 		Map<String, Operation> operations, double op1, double op2
	 * ) throws CalculatorException {
	 * 		final Map<String, Double> results = new HashMap<String, Double>();
	 * 
	 * 		for (Map.Entry<String, Operation> entry : operations.entrySet()) {
	 * 			results.put(entry.getKey(), entry.getValue().calculate(op1, op2));
	 * 		}
	 * 		return results;
	 * 	} 
	 */

	@Override
	public NamedResults mapOperate(
		NamedOperations operations, double op1, double op2
	) throws CalculatorException {
		final NamedResults results = new NamedResults();
		
		final Map<String, Operation> operationsMap = operations.getOperations();
		final Map<String, Double> resultsMap = results.getResults();
		
		for (Map.Entry<String, Operation> entry : operationsMap.entrySet()) {
			resultsMap.put(entry.getKey(), entry.getValue().calculate(op1, op2));
		}
		
		return results;
	}
}
